/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.action.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.dao.MSyozokuDao;
import jp.mosp.system.dto.MSyozokuDto;
import jp.mosp.system.vo.SyozokuMasterCardVo;

public class SyozokuMasterCardAction extends MosPAction {

	// R}h
	private static final String CMD_SYOZOKU_CARD_SHOW   = "S2105";	// \(ǉ)
	private static final String CMD_SYOZOKU_CARD_SELECT = "S2106";	// \(I)
	private static final String CMD_SYOZOKU_CARD_INSERT = "S2107";	// o^
	private static final String CMD_SYOZOKU_CARD_UPDATE = "S2108";	// XV
	private static final String CMD_SYOZOKU_CARD_DELETE = "S2109";	// 폜

	/**
	 * RXgN^
	 */
	public SyozokuMasterCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾yѐݒ		
		SyozokuMasterCardVo vo = new SyozokuMasterCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DAȌ
		MSyozokuDao dao;
		dao = new MSyozokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO̎擾
		MSyozokuDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MSyozokuDto ? (MSyozokuDto)obj : null;
		// R}h̏
		if (cmd.equals(CMD_SYOZOKU_CARD_SHOW)) {
			//\(VK)
			vo.setTxtSCode1("");
			vo.setTxtSCode2("");
			vo.setTxtSCode3("");
			vo.setTxtSName("");
			vo.setMode(SyozokuMasterCardVo.MODE_INSERT);
		} else if (cmd.equals(CMD_SYOZOKU_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = dao.findForKey(key1);
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			setMode(vo);
			//ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);			
		} else if (cmd.equals(CMD_SYOZOKU_CARD_INSERT)) {
			//VKo^
			dto = insert(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);			
		} else if (cmd.equals(CMD_SYOZOKU_CARD_UPDATE)) {
			// XV
			dto = update(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);			
		} else if (cmd.equals(CMD_SYOZOKU_CARD_DELETE)) {
			// 폜
			delete(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private MSyozokuDto insert(SyozokuMasterCardVo vo) throws Exception {
		//p[^[̑ÓmF
		vo.validate(true);
		//DAȌ
		MSyozokuDao dao = new MSyozokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		//݃`FbN
		chkDuplicate(dao.findForKey(vo.getTxtSCode1() + vo.getTxtSCode2() + vo.getTxtSCode3()), vo);
		//DTȌ
		MSyozokuDto dto = new MSyozokuDto();
		vo.setDtoFields(dto);
		//f[^̑}
		dao.insert(dto);
		//DTO̍Ď擾
		dto = dao.findForKey(dto.getSCode());
		chkInsert(dto);
		//R~bg
		commit();
		//[hݒ
		setMode(vo);
		//bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return dto;			
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private MSyozokuDto update(SyozokuMasterCardVo vo, MSyozokuDto dto) throws Exception {
		// p[^̑ÓmF
		vo.validate(false);
		// DAȌ
		MSyozokuDao dao = new MSyozokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getTxtSCode1() + vo.getTxtSCode2() + vo.getTxtSCode3()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MSyozokuDto retDto = dao.findForKey(dto.getSCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode(vo);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;		
	}

	/**
	 * f[^폜
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @throws Exception
	 */
	private void delete(SyozokuMasterCardVo vo, MSyozokuDto dto) throws Exception {
		// DAȌ
		MSyozokuDao dao = new MSyozokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.delete(dto);
		// R~bg
		commit();		
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
	}

	/**
	 * [hݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void setMode(SyozokuMasterCardVo vo) throws Exception {
		// [hݒ
		if (hasSystemAuth()) {
			vo.setMode(SyozokuMasterCardVo.MODE_SYSTEM);
		} else {
			vo.setMode(SyozokuMasterCardVo.MODE_UPDATE);
		}
	}

}
